/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.protonpack;

import com.codepoetics.protonpack.functions.TriFunction;
import java.util.Spliterator;
import java.util.function.Consumer;

class TriZippingSpliterator<L, M, R, O>
implements Spliterator<O> {
    private final Spliterator<L> lefts;
    private final Spliterator<M> middles;
    private final Spliterator<R> rights;
    private final TriFunction<L, M, R, O> combiner;
    private boolean middleHadNext = false;
    private boolean rightHadNext = false;

    static <L, M, R, O> Spliterator<O> zipping(Spliterator<L> lefts, Spliterator<M> middles, Spliterator<R> rights, TriFunction<L, M, R, O> combiner) {
        return new TriZippingSpliterator<L, M, R, O>(lefts, middles, rights, combiner);
    }

    private TriZippingSpliterator(Spliterator<L> lefts, Spliterator<M> middles, Spliterator<R> rights, TriFunction<L, M, R, O> combiner) {
        this.lefts = lefts;
        this.rights = rights;
        this.middles = middles;
        this.combiner = combiner;
    }

    @Override
    public boolean tryAdvance(Consumer<? super O> action) {
        this.middleHadNext = false;
        this.rightHadNext = false;
        boolean leftHadNext = this.lefts.tryAdvance((? super T l) -> this.middles.tryAdvance((? super T m) -> {
            this.middleHadNext = true;
            this.rights.tryAdvance((? super T r) -> {
                this.rightHadNext = true;
                action.accept((O)this.combiner.apply(l, m, r));
            });
        }));
        return leftHadNext && this.middleHadNext && this.rightHadNext;
    }

    @Override
    public Spliterator<O> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return Math.min(this.lefts.estimateSize(), Math.min(this.middles.estimateSize(), this.rights.estimateSize()));
    }

    @Override
    public int characteristics() {
        return this.lefts.characteristics() & this.rights.characteristics() & 0xFFFFFFFA;
    }
}

