/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.protonpack;

import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

class InterleavingSpliterator<T>
implements Spliterator<T> {
    private final Spliterator<T>[] spliterators;
    private final Supplier<T[]> bufferSupplier;
    private T[] buffer = null;
    private final Function<T[], Integer> selector;

    public static <T> Spliterator<T> interleaving(Spliterator<T>[] spliterators, Function<T[], Integer> selector) {
        Supplier<T[]> bufferedValues = () -> {
            Object[] values = new Object[spliterators.length];
            for (int i = 0; i < spliterators.length; ++i) {
                int stableIndex = i;
                spliterators[i].tryAdvance(t -> {
                    values[stableIndex] = t;
                });
            }
            return values;
        };
        return new InterleavingSpliterator<T>(spliterators, bufferedValues, selector);
    }

    private InterleavingSpliterator(Spliterator<T>[] spliterators, Supplier<T[]> bufferSupplier, Function<T[], Integer> selector) {
        this.spliterators = spliterators;
        this.bufferSupplier = bufferSupplier;
        this.selector = selector;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        if (this.buffer == null) {
            this.buffer = this.bufferSupplier.get();
        }
        if (Stream.of(this.buffer).allMatch(Predicate.isEqual(null))) {
            return false;
        }
        int selected = this.selector.apply(this.buffer);
        action.accept(this.buffer[selected]);
        if (!this.spliterators[selected].tryAdvance(t -> {
            this.buffer[selected] = t;
        })) {
            this.buffer[selected] = null;
        }
        return true;
    }

    @Override
    public Spliterator<T> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        if (Stream.of(this.spliterators).anyMatch(s -> s.estimateSize() == Long.MAX_VALUE)) {
            return Long.MAX_VALUE;
        }
        return Stream.of(this.spliterators).mapToLong(Spliterator::estimateSize).sum();
    }

    @Override
    public long getExactSizeIfKnown() {
        if (Stream.of(this.spliterators).allMatch(s -> s.hasCharacteristics(64))) {
            return Stream.of(this.spliterators).mapToLong(Spliterator::getExactSizeIfKnown).sum();
        }
        return -1L;
    }

    @Override
    public int characteristics() {
        return 0;
    }
}

