/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.impl.Alias;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.ElementDescriber;
import com.codeborne.selenide.impl.Plugins;
import com.codeborne.selenide.impl.WebElementSelector;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class BySelectorCollection
implements CollectionSource {
    private static final ElementDescriber describe = Plugins.inject(ElementDescriber.class);
    private final Driver driver;
    private final SearchContext parent;
    private final By selector;
    private Alias alias = Alias.NONE;

    public BySelectorCollection(Driver driver, By selector) {
        this(driver, null, selector);
    }

    public BySelectorCollection(Driver driver, @Nullable SearchContext parent, By selector) {
        this.driver = driver;
        this.parent = parent;
        this.selector = selector;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public List<WebElement> getElements() {
        SearchContext searchContext = this.parent == null ? this.driver.getWebDriver() : this.parent;
        return WebElementSelector.instance.findElements(this.driver, searchContext, this.selector);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public WebElement getElement(int index) {
        SearchContext searchContext;
        Object object = searchContext = this.parent == null ? this.driver.getWebDriver() : this.parent;
        if (index == 0) {
            return WebElementSelector.instance.findElement(this.driver, searchContext, this.selector);
        }
        return WebElementSelector.instance.findElements(this.driver, searchContext, this.selector).get(index);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String description() {
        return this.alias.getOrElse(this::composeDescription);
    }

    @Nonnull
    private String composeDescription() {
        return this.parent == null ? describe.selector(this.selector) : (this.parent instanceof SelenideElement ? ((SelenideElement)this.parent).getSearchCriteria() + "/" + describe.selector(this.selector) : describe.selector(this.selector));
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public Driver driver() {
        return this.driver;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = new Alias(alias);
    }
}

