/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.proxy;

import com.browserup.bup.filters.RequestFilter;
import com.browserup.bup.util.HttpMessageContents;
import com.browserup.bup.util.HttpMessageInfo;
import com.codeborne.selenide.proxy.RequestMatcher;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MockResponseFilter
implements RequestFilter {
    private static final int HTTP_STATUS_OK = 200;
    private static final byte[] EMPTY_RESPONSE = new byte[0];
    private final Map<String, ResponseMock> mocks = new LinkedHashMap<String, ResponseMock>();

    public void mockText(String name, RequestMatcher requestMatcher, Supplier<String> mockedResponse) {
        this.mockBytes(name, requestMatcher, () -> ((String)mockedResponse.get()).getBytes(StandardCharsets.UTF_8));
    }

    public void mockText(String name, RequestMatcher requestMatcher, int status, Supplier<String> mockedResponse) {
        this.mockBytes(name, requestMatcher, status, () -> ((String)mockedResponse.get()).getBytes(StandardCharsets.UTF_8));
    }

    public void mockBytes(String name, RequestMatcher requestMatcher, Supplier<byte[]> mockedResponse) {
        this.mockBytes(name, requestMatcher, 200, mockedResponse);
    }

    public void mockBytes(String name, RequestMatcher requestMatcher, int status, Supplier<byte[]> mockedResponse) {
        if (this.mocks.containsKey(name)) {
            throw new IllegalArgumentException("Response filter already registered: " + name);
        }
        this.mocks.put(name, new ResponseMock(name, requestMatcher, status, mockedResponse));
    }

    public void reset(String name) {
        if (this.mocks.remove(name) == null) {
            throw new IllegalArgumentException("Response filter was not registered: " + name);
        }
    }

    public void resetAll() {
        this.mocks.clear();
    }

    @Nullable
    public HttpResponse filterRequest(HttpRequest request, HttpMessageContents contents, HttpMessageInfo messageInfo) {
        for (ResponseMock mock : this.mocks.values()) {
            if (!mock.requestMatcher.match(request, contents, messageInfo)) continue;
            return request.method().equals((Object)HttpMethod.OPTIONS) ? this.mockOptionsRequest(request, mock) : this.mockRequest(request, mock);
        }
        return null;
    }

    @Nonnull
    @CheckReturnValue
    private DefaultFullHttpResponse mockOptionsRequest(HttpRequest request, ResponseMock mock) {
        HttpHeaders headers = new DefaultHttpHeaders().add("Content-Length", (Object)"0").add("Access-Control-Allow-Methods", (Object)"*").add("Access-Control-Allow-Headers", (Object)"*").add("Access-Control-Allow-Origin", (Object)"*").add("Access-Control-Max-Age", (Object)"0").add("X-Mocked-By", (Object)mock.name);
        return MockResponseFilter.response(request, 200, Unpooled.wrappedBuffer((byte[])EMPTY_RESPONSE), headers);
    }

    @Nonnull
    @CheckReturnValue
    private DefaultFullHttpResponse mockRequest(HttpRequest request, ResponseMock mock) {
        ByteBuf content = Unpooled.wrappedBuffer((byte[])mock.mockedResponse.get());
        HttpHeaders headers = new DefaultHttpHeaders().add("Content-Length", (Object)content.readableBytes()).set("Access-Control-Allow-Origin", (Object)"*").add("X-Mocked-By", (Object)mock.name);
        return MockResponseFilter.response(request, mock.status, content, headers);
    }

    @Nonnull
    @CheckReturnValue
    private static DefaultFullHttpResponse response(HttpRequest request, int status, ByteBuf content, HttpHeaders headers) {
        return new DefaultFullHttpResponse(request.protocolVersion(), HttpResponseStatus.valueOf((int)status), content, headers, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
    }

    @ParametersAreNonnullByDefault
    private static final class ResponseMock {
        private final String name;
        private final RequestMatcher requestMatcher;
        private final int status;
        private final Supplier<byte[]> mockedResponse;

        private ResponseMock(String name, RequestMatcher requestMatcher, int status, Supplier<byte[]> mockedResponse) {
            this.name = name;
            this.requestMatcher = requestMatcher;
            this.status = status;
            this.mockedResponse = mockedResponse;
        }
    }
}

