/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.impl.Cleanup;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class WindowsCloser {
    private static final Logger log = LoggerFactory.getLogger(WindowsCloser.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    public <T> T runAndCloseArisedWindows(WebDriver webDriver, Supplier<T> lambda) {
        String originalWindowHandle = webDriver.getWindowHandle();
        Set windowsBefore = webDriver.getWindowHandles();
        try {
            T t = lambda.get();
            return t;
        }
        finally {
            this.closeArisedWindows(webDriver, originalWindowHandle, windowsBefore);
        }
    }

    private void closeArisedWindows(WebDriver webDriver, String originalWindowHandle, Set<String> windowsBefore) {
        Set<String> newWindows = this.newWindows(webDriver, windowsBefore);
        if (!newWindows.isEmpty()) {
            this.closeWindows(webDriver, newWindows);
            webDriver.switchTo().window(originalWindowHandle);
        }
    }

    @CheckReturnValue
    @Nonnull
    private Set<String> newWindows(WebDriver webDriver, Set<String> windowsBefore) {
        Set windowHandles = webDriver.getWindowHandles();
        HashSet<String> newWindows = new HashSet<String>(windowHandles);
        newWindows.removeAll(windowsBefore);
        return newWindows;
    }

    private void closeWindows(WebDriver webDriver, Set<String> windows) {
        log.info("File has been opened in a new window, let's close {} new windows", (Object)windows.size());
        for (String newWindow : windows) {
            this.closeWindow(webDriver, newWindow);
        }
    }

    private void closeWindow(WebDriver webDriver, String window) {
        log.info("  Let's close {}", (Object)window);
        try {
            webDriver.switchTo().window(window);
            webDriver.close();
        }
        catch (NoSuchWindowException windowHasBeenClosedMeanwhile) {
            log.info("  Failed to close {}: {}", (Object)window, (Object)Cleanup.of.webdriverExceptionMessage(windowHasBeenClosedMeanwhile));
        }
        catch (Exception e) {
            log.warn("  Failed to close {}", (Object)window, (Object)e);
        }
    }
}

