/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.commands.Util;
import com.codeborne.selenide.impl.CollectionElement;
import com.codeborne.selenide.impl.CollectionSource;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SelenideElementIterator<T extends SelenideElement>
implements Iterator<T> {
    protected final CollectionSource collection;
    private final Class<T> clazz;
    protected int index;

    @SafeVarargs
    public SelenideElementIterator(CollectionSource collection, T ... clazz) {
        this.collection = collection;
        this.clazz = Util.classOf(clazz);
    }

    @Override
    @CheckReturnValue
    public boolean hasNext() {
        return this.collection.getElements().size() > this.index;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next element present in collection %s at index %d".formatted(this.collection, this.index));
        }
        return CollectionElement.wrap(this.clazz, this.collection, this.index++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove elements from web page");
    }
}

