/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.SelenideElementProxy;
import com.codeborne.selenide.impl.WebElementSource;
import java.lang.reflect.Proxy;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class LastCollectionElement
extends WebElementSource {
    private final CollectionSource collection;

    public static SelenideElement wrap(CollectionSource collection) {
        return (SelenideElement)Proxy.newProxyInstance(collection.getClass().getClassLoader(), new Class[]{SelenideElement.class}, new SelenideElementProxy(new LastCollectionElement(collection)));
    }

    LastCollectionElement(CollectionSource collection) {
        this.collection = collection;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public Driver driver() {
        return this.collection.driver();
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public WebElement getWebElement() {
        return this.lastElementOf(this.collection.getElements());
    }

    private <T> T lastElementOf(List<T> collection) {
        return collection.get(collection.size() - 1);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String getSearchCriteria() {
        return this.collection.getSearchCriteria() + ":last";
    }

    @Override
    @Nonnull
    public String description() {
        return this.getAlias().getOrElse(() -> this.collection.shortDescription() + ":last");
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public ElementNotFound createElementNotFoundError(WebElementCondition condition, Throwable cause) {
        if (this.collection.getElements().isEmpty()) {
            return new ElementNotFound(this.driver(), this.getAlias(), this.getSearchCriteria(), Condition.visible, cause);
        }
        return super.createElementNotFoundError(condition, cause);
    }
}

