/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.Alias;
import com.codeborne.selenide.impl.CollectionSource;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class HeadOfCollection
implements CollectionSource {
    private final CollectionSource originalCollection;
    private final int size;
    private Alias alias = Alias.NONE;

    public HeadOfCollection(CollectionSource originalCollection, int size) {
        this.originalCollection = originalCollection;
        this.size = size;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public Driver driver() {
        return this.originalCollection.driver();
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public List<WebElement> getElements() {
        List<WebElement> source = this.originalCollection.getElements();
        return source.subList(0, Math.min(source.size(), this.size));
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public WebElement getElement(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", size: " + this.size);
        }
        return this.originalCollection.getElement(index);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String getSearchCriteria() {
        return this.originalCollection.description() + ":first(" + this.size + ")";
    }

    public String toString() {
        return this.originalCollection + ":first(" + this.size + ")";
    }

    @Override
    @Nonnull
    public Alias getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = new Alias(alias);
    }
}

