/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import java.util.Collection;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public interface ElementDescriber {
    @CheckReturnValue
    @Nonnull
    public String fully(Driver var1, @Nullable WebElement var2);

    @CheckReturnValue
    @Nonnull
    public String briefly(Driver var1, @Nonnull WebElement var2);

    @CheckReturnValue
    @Nonnull
    public String selector(By var1);

    @CheckReturnValue
    @Nonnull
    default public String fully(Driver driver, @Nullable Collection<WebElement> elements) {
        if (elements == null) {
            return "[not loaded yet...]";
        }
        if (elements.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append("[").append(System.lineSeparator()).append("\t");
        for (WebElement element : elements) {
            if (sb.length() > 4) {
                sb.append(",").append(System.lineSeparator()).append("\t");
            }
            sb.append(this.fully(driver, element));
        }
        sb.append(System.lineSeparator()).append("]");
        return sb.toString();
    }
}

