/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.SelenideElementProxy;
import com.codeborne.selenide.impl.WebElementSource;
import java.lang.reflect.Proxy;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class CollectionElementByCondition
extends WebElementSource {
    private final CollectionSource collection;
    private final WebElementCondition condition;

    @CheckReturnValue
    @Nonnull
    public static SelenideElement wrap(CollectionSource collection, WebElementCondition condition) {
        return (SelenideElement)Proxy.newProxyInstance(collection.getClass().getClassLoader(), new Class[]{SelenideElement.class}, new SelenideElementProxy(new CollectionElementByCondition(collection, condition)));
    }

    CollectionElementByCondition(CollectionSource collection, WebElementCondition condition) {
        this.collection = collection;
        this.condition = condition;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public Driver driver() {
        return this.collection.driver();
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public WebElement getWebElement() {
        List<WebElement> list = this.collection.getElements();
        for (WebElement element : list) {
            if (this.condition.check(this.driver(), element).verdict() != CheckResult.Verdict.ACCEPT) continue;
            return element;
        }
        throw new NoSuchElementException("Cannot locate an element " + this.description());
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String getSearchCriteria() {
        return this.collection.getSearchCriteria() + ".findBy(" + this.condition + ")";
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String description() {
        return this.getAlias().getOrElse(() -> this.collection.shortDescription() + ".findBy(" + this.condition + ")");
    }
}

