/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.files;

import java.io.File;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DownloadedFile {
    private final File file;
    private final Map<String, String> headers;

    public DownloadedFile(File file, Map<String, String> headers) {
        this.file = file;
        this.headers = headers;
    }

    @CheckReturnValue
    @Nonnull
    public File getFile() {
        return this.file;
    }

    @CheckReturnValue
    public boolean hasContentDispositionHeader() {
        return this.headers.containsKey("content-disposition");
    }

    @Nullable
    public String getContentType() {
        return this.headers.get("content-type");
    }

    public String toString() {
        return String.format("%s (modified %s ms ago)", this.file.getName(), System.currentTimeMillis() - this.file.lastModified());
    }
}

