/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.ex;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ex.ErrorFormatter;
import com.codeborne.selenide.ex.Strings;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.Plugins;
import com.codeborne.selenide.impl.ScreenShotLaboratory;
import com.codeborne.selenide.impl.Screenshot;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebDriverException;
import org.opentest4j.AssertionFailedError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class UIAssertionError
extends AssertionFailedError {
    private static final Logger log = LoggerFactory.getLogger(UIAssertionError.class);
    protected static final ErrorFormatter errorFormatter = Plugins.inject(ErrorFormatter.class);
    private final Driver driver;
    private Screenshot screenshot = Screenshot.none();
    private long timeoutMs;

    protected UIAssertionError(Driver driver, String message) {
        super(message);
        this.driver = driver;
    }

    public UIAssertionError(Driver driver, String message, @Nullable Object expected, @Nullable Object actual) {
        super(message, expected, actual);
        this.driver = driver;
    }

    protected UIAssertionError(Driver driver, String message, @Nullable Object expected, @Nullable Object actual, long timeoutMs) {
        super(message, expected, actual);
        this.driver = driver;
        this.timeoutMs = timeoutMs;
    }

    protected UIAssertionError(Driver driver, String message, @Nullable Throwable cause) {
        super(message, cause);
        this.driver = driver;
    }

    protected UIAssertionError(Driver driver, String message, long timeoutMs, @Nullable Throwable cause) {
        super(message, cause);
        this.driver = driver;
        this.timeoutMs = timeoutMs;
    }

    protected UIAssertionError(Driver driver, String message, @Nullable Object expected, @Nullable Object actual, @Nullable Throwable cause) {
        super(message, expected, actual, cause);
        this.driver = driver;
    }

    protected UIAssertionError(Driver driver, String message, @Nullable Object expected, @Nullable Object actual, @Nullable Throwable cause, long timeoutMs) {
        super(message, expected, actual, cause);
        this.driver = driver;
        this.timeoutMs = timeoutMs;
    }

    @CheckReturnValue
    public final String getMessage() {
        return Strings.join(super.getMessage(), this.generateErrorDetails());
    }

    @CheckReturnValue
    public final String toString() {
        return this.getMessage();
    }

    @CheckReturnValue
    @Nonnull
    private String generateErrorDetails() {
        return errorFormatter.generateErrorDetails((AssertionError)((Object)this), this.driver, this.screenshot, this.timeoutMs);
    }

    @CheckReturnValue
    public Screenshot getScreenshot() {
        return this.screenshot;
    }

    @CheckReturnValue
    public static Error wrap(Driver driver, Error error, long timeoutMs) {
        return Cleanup.of.isInvalidSelectorError(error) ? error : UIAssertionError.wrapThrowable(driver, error, timeoutMs);
    }

    @CheckReturnValue
    public static Throwable wrap(Driver driver, WebDriverException error, long timeoutMs) {
        return Cleanup.of.isInvalidSelectorError(error) ? error : UIAssertionError.wrapThrowable(driver, error, timeoutMs);
    }

    @CheckReturnValue
    private static UIAssertionError wrapThrowable(Driver driver, Throwable error, long timeoutMs) {
        UIAssertionError uiAssertionError;
        UIAssertionError uiError = error instanceof UIAssertionError ? (uiAssertionError = (UIAssertionError)((Object)error)) : UIAssertionError.wrapToUIAssertionError(driver, error);
        uiError.timeoutMs = timeoutMs;
        if (uiError.screenshot.isPresent()) {
            log.warn("UIAssertionError already has screenshot: {} {} -> {}", new Object[]{((Object)((Object)uiError)).getClass().getName(), uiError.getMessage(), uiError.screenshot});
        } else {
            Config config = driver.config();
            uiError.screenshot = ScreenShotLaboratory.getInstance().takeScreenshot(driver, config.screenshots(), config.savePageSource());
        }
        return uiError;
    }

    @CheckReturnValue
    private static UIAssertionError wrapToUIAssertionError(Driver driver, Throwable error) {
        String message = Cleanup.of.webdriverExceptionMessage(error);
        return new UIAssertionError(driver, message, error);
    }
}

