/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.datetime;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.WebElementCondition;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public abstract class TemporalFormatCondition<T extends TemporalAccessor>
extends WebElementCondition {
    private final String pattern;
    private final DateTimeFormatter format;

    protected TemporalFormatCondition(String name, String pattern) {
        super(name);
        this.pattern = pattern;
        this.format = DateTimeFormatter.ofPattern(pattern);
    }

    @Nonnull
    @CheckReturnValue
    protected abstract TemporalQuery<T> queryFromTemporal();

    @Override
    @Nonnull
    @CheckReturnValue
    public CheckResult check(Driver driver, WebElement element) {
        String value = this.getValueAttribute(element);
        try {
            return new CheckResult(CheckResult.Verdict.ACCEPT, this.format.parse((CharSequence)value, this.queryFromTemporal()));
        }
        catch (DateTimeParseException exception) {
            return new CheckResult(CheckResult.Verdict.REJECT, (Object)value);
        }
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String toString() {
        return String.format("%s \"%s\"", this.getName(), this.pattern);
    }

    @Nonnull
    @CheckReturnValue
    private String getValueAttribute(WebElement element) {
        String value = element.getAttribute("value");
        return value == null ? "" : value;
    }

    @Nonnull
    @CheckReturnValue
    public String format(T value) {
        return this.format.format((TemporalAccessor)value);
    }
}

