/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.commands.GetOwnText;
import com.codeborne.selenide.conditions.CaseInsensitiveTextCondition;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class OwnText
extends CaseInsensitiveTextCondition {
    public OwnText(String expectedText) {
        super("own text", expectedText);
        if (StringUtils.isEmpty((CharSequence)expectedText)) {
            throw new IllegalArgumentException("Argument must not be null or empty string. Use $.shouldHave(exactOwnText(\"\").");
        }
    }

    @Override
    @Nullable
    @CheckReturnValue
    protected String getText(Driver driver, WebElement element) {
        return GetOwnText.getOwnText(driver, element);
    }
}

