/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.WebElementCondition;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class ExplainedCondition<T extends WebElementCondition>
extends WebElementCondition {
    private final T delegate;
    private final String message;

    public ExplainedCondition(T delegate, String message) {
        super(((WebElementCondition)delegate).getName(), ((WebElementCondition)delegate).missingElementSatisfiesCondition());
        this.delegate = delegate;
        this.message = message;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public CheckResult check(Driver driver, WebElement element) {
        return ((WebElementCondition)this.delegate).check(driver, element);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public WebElementCondition negate() {
        return ((WebElementCondition)this.delegate).negate().because(this.message);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String toString() {
        return ((WebElementCondition)this.delegate).toString() + " (because " + this.message + ")";
    }
}

