/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.commands.GetOwnText;
import com.codeborne.selenide.conditions.TextCondition;
import com.codeborne.selenide.impl.Html;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class ExactOwnTextCaseSensitive
extends TextCondition {
    public ExactOwnTextCaseSensitive(String expectedText) {
        super("exact own text case sensitive", expectedText);
    }

    @Override
    @CheckReturnValue
    protected boolean match(String actualText, String expectedText) {
        return Html.text.equalsCaseSensitive(actualText, expectedText);
    }

    @Override
    @Nullable
    @CheckReturnValue
    protected String getText(Driver driver, WebElement element) {
        return GetOwnText.getOwnText(driver, element);
    }
}

