/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.WebElementCondition;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class Attribute
extends WebElementCondition {
    private final String attributeName;

    public Attribute(String attributeName) {
        super("attribute " + attributeName);
        this.attributeName = attributeName;
    }

    @Override
    @Nonnull
    public CheckResult check(Driver driver, WebElement element) {
        String attributeValue = element.getAttribute(this.attributeName);
        return new CheckResult(attributeValue != null, (Object)String.format("%s=\"%s\"", this.attributeName, attributeValue));
    }
}

