/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.conditions.Not;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class And
extends WebElementCondition {
    private final List<? extends WebElementCondition> conditions;

    public And(String name, List<? extends WebElementCondition> conditions) {
        super(name, And.checkedConditionsListCtorArg(conditions).stream().allMatch(WebElementCondition::missingElementSatisfiesCondition));
        this.conditions = conditions;
    }

    private static List<? extends WebElementCondition> checkedConditionsListCtorArg(List<? extends WebElementCondition> conditions) {
        if (conditions.isEmpty()) {
            throw new IllegalArgumentException("conditions list is empty");
        }
        return conditions;
    }

    @Override
    @Nonnull
    public WebElementCondition negate() {
        return new Not(this, this.conditions.stream().map(WebElementCondition::negate).allMatch(WebElementCondition::missingElementSatisfiesCondition));
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public CheckResult check(Driver driver, WebElement element) {
        ArrayList<CheckResult> results = new ArrayList<CheckResult>();
        for (WebElementCondition webElementCondition : this.conditions) {
            CheckResult checkResult = webElementCondition.check(driver, element);
            if (checkResult.verdict() != CheckResult.Verdict.ACCEPT) {
                return checkResult;
            }
            results.add(checkResult);
        }
        String actualValues = results.stream().map(check -> String.valueOf(check.actualValue())).collect(Collectors.joining(", "));
        return new CheckResult(CheckResult.Verdict.ACCEPT, (Object)actualValues);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String toString() {
        return this.getName() + ": " + this.conditions.stream().map(WebElementCondition::toString).collect(Collectors.joining(" and "));
    }
}

