/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.impl.Alias;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.WebElementSource;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class GetOptions
implements Command<ElementsCollection> {
    @Override
    public ElementsCollection execute(SelenideElement proxy, WebElementSource selectElement, @Nullable Object[] args) {
        return new ElementsCollection(new OptionsCollection(selectElement));
    }

    private static class OptionsCollection
    implements CollectionSource {
        private final WebElementSource selectElement;
        private Alias alias = Alias.NONE;

        private OptionsCollection(WebElementSource selectElement) {
            this.selectElement = selectElement;
        }

        @Override
        @CheckReturnValue
        @Nonnull
        public List<WebElement> getElements() {
            return (List)this.selectElement.driver().executeJavaScript("return arguments[0].options", this.selectElement.getWebElement());
        }

        @Override
        @CheckReturnValue
        @Nonnull
        public WebElement getElement(int index) {
            return (WebElement)this.selectElement.driver().executeJavaScript("return arguments[0].options[arguments[1]]", this.selectElement.getWebElement(), index);
        }

        @Override
        @CheckReturnValue
        @Nonnull
        public String getSearchCriteria() {
            return this.selectElement.description() + " options";
        }

        public String toString() {
            return this.selectElement + " options";
        }

        @Override
        @CheckReturnValue
        @Nonnull
        public Driver driver() {
            return this.selectElement.driver();
        }

        @Override
        @Nonnull
        public Alias getAlias() {
            return this.alias;
        }

        @Override
        public void setAlias(String alias) {
            this.alias = new Alias(alias);
        }
    }
}

