/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.ClickMethod;
import com.codeborne.selenide.ClickOptions;
import com.codeborne.selenide.Command;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.commands.Util;
import com.codeborne.selenide.impl.JavaScript;
import com.codeborne.selenide.impl.WebElementSource;
import java.time.Duration;
import java.util.Arrays;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class Click
implements Command<SelenideElement> {
    private final JavaScript jsSource = new JavaScript("click.js");

    @Override
    @Nonnull
    public SelenideElement execute(SelenideElement proxy, WebElementSource locator, @Nullable Object[] args) {
        ClickOptions clickOptions = this.options(args);
        this.click(locator.driver(), this.findElement(locator, clickOptions.isForce()), clickOptions);
        return proxy;
    }

    @Nonnull
    @CheckReturnValue
    protected ClickOptions options(@Nullable Object[] args) {
        return switch (Util.size(args)) {
            case 0 -> ClickOptions.usingDefaultMethod();
            case 1 -> (ClickOptions)Util.firstOf(args);
            default -> throw new IllegalArgumentException("Unsupported click arguments: " + Arrays.toString(args));
        };
    }

    @Nonnull
    @CheckReturnValue
    protected WebElement findElement(WebElementSource locator, boolean force) {
        return force ? locator.getWebElement() : locator.findAndAssertElementIsClickable();
    }

    protected void click(Driver driver, WebElement webElement, ClickOptions clickOptions) {
        Duration timeout = clickOptions.timeout();
        if (timeout == null || timeout.toMillis() == driver.config().pageLoadTimeout()) {
            this.doClick(driver, webElement, clickOptions);
        } else {
            this.withTimeout(driver, timeout, () -> this.doClick(driver, webElement, clickOptions));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withTimeout(Driver driver, Duration timeout, Runnable lambda) {
        WebDriver.Timeouts wdTimeouts = driver.getWebDriver().manage().timeouts();
        Duration originalPageLoadTimeout = wdTimeouts.getPageLoadTimeout();
        try {
            wdTimeouts.pageLoadTimeout(timeout);
            lambda.run();
        }
        finally {
            wdTimeouts.pageLoadTimeout(originalPageLoadTimeout);
        }
    }

    private void doClick(Driver driver, WebElement webElement, ClickOptions clickOptions) {
        ClickMethod method = this.detectMethod(driver, clickOptions);
        switch (method) {
            case DEFAULT: {
                this.defaultClick(driver, webElement, clickOptions.offsetX(), clickOptions.offsetY());
                break;
            }
            case JS: {
                this.clickViaJS(driver, webElement, clickOptions.offsetX(), clickOptions.offsetY());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown click option: " + method);
            }
        }
    }

    @Nonnull
    private ClickMethod detectMethod(Driver driver, ClickOptions clickOptions) {
        ClickMethod method = clickOptions.clickMethod();
        return method == ClickMethod.DEFAULT && driver.config().clickViaJs() ? ClickMethod.JS : method;
    }

    protected void defaultClick(Driver driver, WebElement element, int offsetX, int offsetY) {
        if (this.isCenter(offsetX, offsetY)) {
            element.click();
        } else {
            driver.actions().moveToElement(element, offsetX, offsetY).click().perform();
        }
    }

    protected boolean isCenter(int offsetX, int offsetY) {
        return offsetX == 0 && offsetY == 0;
    }

    protected void clickViaJS(Driver driver, WebElement element, int offsetX, int offsetY) {
        this.jsSource.execute(driver, element, offsetX, offsetY);
    }
}

