/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.collections;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.WebElementsCondition;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.MatcherError;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.ElementDescriber;
import com.codeborne.selenide.impl.Plugins;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public abstract class PredicateCollectionCondition
extends WebElementsCondition {
    private static final ElementDescriber describe = Plugins.inject(ElementDescriber.class);
    protected final String matcher;
    protected final String description;
    protected final Predicate<WebElement> predicate;

    protected PredicateCollectionCondition(String matcher, String description, Predicate<WebElement> predicate) {
        this.matcher = matcher;
        this.description = description;
        this.predicate = predicate;
    }

    @Override
    public void fail(CollectionSource collection, CheckResult lastCheckResult, @Nullable Exception cause, long timeoutMs) {
        List elements = (List)lastCheckResult.getActualValue();
        if (elements == null || elements.isEmpty()) {
            throw new ElementNotFound(collection, this.toString(), timeoutMs, (Throwable)cause);
        }
        throw new MatcherError(this.explanation, this.toString(), describe.fully(collection.driver(), elements), collection, cause, timeoutMs);
    }

    @Override
    public String toString() {
        return String.format("%s elements to match [%s] predicate", this.matcher, this.description);
    }
}

