/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.collections;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.WebElementsCondition;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.TextsMismatch;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.ElementCommunicator;
import com.codeborne.selenide.impl.Html;
import com.codeborne.selenide.impl.Plugins;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class ExactTexts
extends WebElementsCondition {
    private static final ElementCommunicator communicator = Plugins.inject(ElementCommunicator.class);
    protected final List<String> expectedTexts;

    public ExactTexts(String ... expectedTexts) {
        this(Arrays.asList(expectedTexts));
    }

    public ExactTexts(List<String> expectedTexts) {
        if (expectedTexts.isEmpty()) {
            throw new IllegalArgumentException("No expected texts given");
        }
        this.expectedTexts = Collections.unmodifiableList(expectedTexts);
    }

    @Override
    @Nonnull
    public CheckResult check(Driver driver, List<WebElement> elements) {
        List<String> actualTexts = communicator.texts(driver, elements);
        if (actualTexts.size() != this.expectedTexts.size()) {
            String message = String.format("List size mismatch (expected: %s, actual: %s)", this.expectedTexts.size(), actualTexts.size());
            return CheckResult.rejected(message, actualTexts);
        }
        for (int i = 0; i < this.expectedTexts.size(); ++i) {
            String expectedText = this.expectedTexts.get(i);
            String actualText = actualTexts.get(i);
            if (this.check(actualText, expectedText)) continue;
            String message = String.format("Text #%s mismatch (expected: \"%s\", actual: \"%s\")", i, expectedText, actualText);
            return CheckResult.rejected(message, actualTexts);
        }
        return CheckResult.accepted();
    }

    @CheckReturnValue
    protected boolean check(String actualText, String expectedText) {
        return Html.text.equals(actualText, expectedText);
    }

    @Override
    public void fail(CollectionSource collection, CheckResult lastCheckResult, @Nullable Exception cause, long timeoutMs) {
        List actualTexts = (List)lastCheckResult.getActualValue();
        if (actualTexts == null || actualTexts.isEmpty()) {
            throw new ElementNotFound(collection, this.toString(), timeoutMs, (Throwable)cause);
        }
        String message = lastCheckResult.getMessageOrElse(() -> "Texts mismatch");
        throw new TextsMismatch(message, collection, this.expectedTexts, actualTexts, this.explanation, timeoutMs, cause);
    }

    @Override
    public String toString() {
        return "Exact texts " + this.expectedTexts;
    }
}

