/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.collections;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.WebElementsCondition;
import com.codeborne.selenide.ex.ListSizeMismatch;
import com.codeborne.selenide.impl.CollectionSource;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
abstract class CollectionSizeCondition
extends WebElementsCondition {
    private final String operator;
    protected final int expectedSize;

    CollectionSizeCondition(String operator, int expectedSize) {
        this.operator = operator;
        this.expectedSize = expectedSize;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public CheckResult check(Driver driver, List<WebElement> elements) {
        int size = elements.size();
        return new CheckResult(this.apply(size), (Object)size);
    }

    @Override
    public void fail(CollectionSource collection, CheckResult lastCheckResult, @Nullable Exception cause, long timeoutMs) {
        int actualSize = lastCheckResult.getActualValueOrElse(0);
        throw new ListSizeMismatch(this.operator, this.expectedSize, actualSize, this.explanation, collection, cause, timeoutMs);
    }

    @Override
    public boolean missingElementsSatisfyCondition() {
        return this.apply(0);
    }

    protected abstract boolean apply(int var1);
}

