/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.conditions.ExplainedCondition;
import com.codeborne.selenide.conditions.Not;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.openqa.selenium.WebElement;

public abstract class WebElementCondition {
    protected final String name;
    protected final boolean missingElementSatisfiesCondition;

    protected WebElementCondition(String name) {
        this(name, false);
    }

    protected WebElementCondition(String name, boolean missingElementSatisfiesCondition) {
        this.name = name;
        this.missingElementSatisfiesCondition = missingElementSatisfiesCondition;
    }

    @Nonnull
    @CheckReturnValue
    public abstract CheckResult check(Driver var1, WebElement var2);

    @Nonnull
    @CheckReturnValue
    public WebElementCondition negate() {
        return new Not(this, this.missingElementSatisfiesCondition);
    }

    @Nonnull
    @CheckReturnValue
    public WebElementCondition because(String message) {
        return new ExplainedCondition<WebElementCondition>(this, message);
    }

    @Nonnull
    @CheckReturnValue
    public String toString() {
        return this.name;
    }

    @Nonnull
    @CheckReturnValue
    public String getName() {
        return this.name;
    }

    @CheckReturnValue
    public boolean missingElementSatisfiesCondition() {
        return this.missingElementSatisfiesCondition;
    }

    public WebElementCondition or(final WebElementCondition alternative) {
        return new WebElementCondition("%s OR %s".formatted(this.toString(), alternative.toString())){

            @Override
            @Nonnull
            public CheckResult check(Driver driver, WebElement element) {
                CheckResult r1 = WebElementCondition.this.check(driver, element);
                return r1.verdict() == CheckResult.Verdict.ACCEPT ? r1 : alternative.check(driver, element);
            }

            @Override
            @Nonnull
            @CheckReturnValue
            public WebElementCondition negate() {
                return new Not(this, Stream.of(WebElementCondition.this, alternative).map(WebElementCondition::negate).anyMatch(WebElementCondition::missingElementSatisfiesCondition));
            }
        };
    }
}

