/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.WebElementsCondition;
import com.codeborne.selenide.collections.AllMatch;
import com.codeborne.selenide.collections.AnyMatch;
import com.codeborne.selenide.collections.Attributes;
import com.codeborne.selenide.collections.ContainExactTextsCaseSensitive;
import com.codeborne.selenide.collections.ExactTexts;
import com.codeborne.selenide.collections.ExactTextsCaseSensitive;
import com.codeborne.selenide.collections.ExactTextsCaseSensitiveInAnyOrder;
import com.codeborne.selenide.collections.ItemWithText;
import com.codeborne.selenide.collections.ListSize;
import com.codeborne.selenide.collections.NoneMatch;
import com.codeborne.selenide.collections.SizeGreaterThan;
import com.codeborne.selenide.collections.SizeGreaterThanOrEqual;
import com.codeborne.selenide.collections.SizeLessThan;
import com.codeborne.selenide.collections.SizeLessThanOrEqual;
import com.codeborne.selenide.collections.SizeNotEqual;
import com.codeborne.selenide.collections.Texts;
import com.codeborne.selenide.collections.TextsInAnyOrder;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public final class CollectionCondition {
    public static WebElementsCondition empty = CollectionCondition.size(0);

    @CheckReturnValue
    public static WebElementsCondition size(int expectedSize) {
        return new ListSize(expectedSize);
    }

    @CheckReturnValue
    public static WebElementsCondition sizeGreaterThan(int expectedSize) {
        return new SizeGreaterThan(expectedSize);
    }

    @CheckReturnValue
    public static WebElementsCondition sizeGreaterThanOrEqual(int expectedSize) {
        return new SizeGreaterThanOrEqual(expectedSize);
    }

    @CheckReturnValue
    public static WebElementsCondition sizeLessThan(int expectedSize) {
        return new SizeLessThan(expectedSize);
    }

    @CheckReturnValue
    public static WebElementsCondition sizeLessThanOrEqual(int size) {
        return new SizeLessThanOrEqual(size);
    }

    @CheckReturnValue
    public static WebElementsCondition sizeNotEqual(int expectedSize) {
        return new SizeNotEqual(expectedSize);
    }

    @CheckReturnValue
    public static WebElementsCondition texts(String ... expectedTexts) {
        return new Texts(expectedTexts);
    }

    @CheckReturnValue
    public static WebElementsCondition texts(List<String> expectedTexts) {
        return new Texts(expectedTexts);
    }

    @CheckReturnValue
    public static WebElementsCondition textsInAnyOrder(String ... expectedTexts) {
        return new TextsInAnyOrder(expectedTexts);
    }

    @CheckReturnValue
    public static WebElementsCondition textsInAnyOrder(List<String> expectedTexts) {
        return new TextsInAnyOrder(expectedTexts);
    }

    @CheckReturnValue
    public static WebElementsCondition exactTexts(String ... expectedTexts) {
        return new ExactTexts(expectedTexts);
    }

    @CheckReturnValue
    public static WebElementsCondition exactTexts(List<String> expectedTexts) {
        return new ExactTexts(expectedTexts);
    }

    @CheckReturnValue
    public static WebElementsCondition attributes(String attribute, String ... expectedValues) {
        return CollectionCondition.attributes(attribute, Arrays.asList(expectedValues));
    }

    @CheckReturnValue
    public static WebElementsCondition attributes(String attribute, List<String> expectedValues) {
        return new Attributes(attribute, expectedValues);
    }

    @CheckReturnValue
    public static WebElementsCondition exactTextsCaseSensitive(String ... expectedTexts) {
        return new ExactTextsCaseSensitive(expectedTexts);
    }

    @CheckReturnValue
    public static WebElementsCondition exactTextsCaseSensitive(List<String> expectedTexts) {
        return new ExactTextsCaseSensitive(expectedTexts);
    }

    @CheckReturnValue
    public static WebElementsCondition anyMatch(String description, Predicate<WebElement> predicate) {
        return new AnyMatch(description, predicate);
    }

    @CheckReturnValue
    public static WebElementsCondition allMatch(String description, Predicate<WebElement> predicate) {
        return new AllMatch(description, predicate);
    }

    @CheckReturnValue
    public static WebElementsCondition noneMatch(String description, Predicate<WebElement> predicate) {
        return new NoneMatch(description, predicate);
    }

    @CheckReturnValue
    public static WebElementsCondition itemWithText(String expectedText) {
        return new ItemWithText(expectedText);
    }

    @CheckReturnValue
    public static WebElementsCondition containExactTextsCaseSensitive(String ... expectedTexts) {
        return new ContainExactTextsCaseSensitive(expectedTexts);
    }

    @CheckReturnValue
    public static WebElementsCondition containExactTextsCaseSensitive(List<String> expectedTexts) {
        return new ContainExactTextsCaseSensitive(expectedTexts);
    }

    @CheckReturnValue
    public static WebElementsCondition exactTextsCaseSensitiveInAnyOrder(List<String> expectedTexts) {
        return new ExactTextsCaseSensitiveInAnyOrder(expectedTexts);
    }

    @CheckReturnValue
    public static WebElementsCondition exactTextsCaseSensitiveInAnyOrder(String ... expectedTexts) {
        return new ExactTextsCaseSensitiveInAnyOrder(expectedTexts);
    }
}

