/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Credentials;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class BearerTokenCredentials
implements Credentials {
    private static final Pattern REGEX_ANY_CHAR = Pattern.compile(".");
    public final String domain;
    public final String token;

    public BearerTokenCredentials(String domain, String token) {
        this.domain = domain;
        this.token = token;
    }

    @Override
    @Nonnull
    public String domain() {
        return this.domain;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String encode() {
        return this.token;
    }

    @CheckReturnValue
    @Nonnull
    public String toString() {
        return String.format("%s:%s", this.domain, REGEX_ANY_CHAR.matcher(this.token).replaceAll("*"));
    }
}

