/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Credentials;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class BasicAuthCredentials
implements Credentials {
    private static final Pattern REGEX_ANY_CHAR = Pattern.compile(".");
    public final String domain;
    public final String login;
    public final String password;

    public BasicAuthCredentials(String login, String password) {
        this("", login, password);
    }

    public BasicAuthCredentials(String domain, String login, String password) {
        this.domain = domain;
        this.login = login;
        this.password = password;
    }

    @Override
    @Nonnull
    public String domain() {
        return this.domain;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String encode() {
        byte[] credentialsBytes = this.combine().getBytes(StandardCharsets.UTF_8);
        return Base64.getEncoder().encodeToString(credentialsBytes);
    }

    private String combine() {
        return String.format("%s:%s", this.login, this.password);
    }

    @CheckReturnValue
    @Nonnull
    public String toString() {
        return String.format("%s:%s:%s", this.domain, this.login, REGEX_ANY_CHAR.matcher(this.password).replaceAll("*"));
    }
}

