/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.impl.ElementDescriber;
import com.codeborne.selenide.impl.Plugins;
import com.codeborne.selenide.impl.SelenideElementProxy;
import com.codeborne.selenide.impl.WebElementSource;
import java.lang.reflect.Proxy;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class WebElementWrapper
extends WebElementSource {
    private final ElementDescriber describe = Plugins.inject(ElementDescriber.class);
    private final Driver driver;
    private final WebElement delegate;
    @Nullable
    private final String searchCriteria;

    public static SelenideElement wrap(Driver driver, WebElement element) {
        return WebElementWrapper.wrap(SelenideElement.class, driver, element);
    }

    public static <T extends SelenideElement> T wrap(Class<T> clazz, Driver driver, WebElement element) {
        return WebElementWrapper.wrap(clazz, driver, element, null);
    }

    public static SelenideElement wrap(Driver driver, WebElement element, @Nullable String searchCriteria) {
        return WebElementWrapper.wrap(SelenideElement.class, driver, element, searchCriteria);
    }

    public static <T extends SelenideElement> T wrap(Class<T> clazz, Driver driver, WebElement element, @Nullable String searchCriteria) {
        return (T)(clazz.isInstance(element) ? (SelenideElement)clazz.cast(element) : (SelenideElement)Proxy.newProxyInstance(element.getClass().getClassLoader(), new Class[]{clazz}, new SelenideElementProxy(new WebElementWrapper(driver, element, searchCriteria))));
    }

    protected WebElementWrapper(Driver driver, WebElement delegate, @Nullable String searchCriteria) {
        this.driver = driver;
        this.delegate = delegate;
        this.searchCriteria = searchCriteria;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public WebElement getWebElement() {
        return this.delegate;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String getSearchCriteria() {
        return this.searchCriteria != null ? this.searchCriteria : this.describe.briefly(this.driver, this.delegate);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String toString() {
        return this.getAlias().getOrElse(() -> this.describe.fully(this.driver(), this.delegate));
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public Driver driver() {
        return this.driver;
    }
}

