/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import java.io.File;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Screenshot {
    private final File imageFile;
    private final String image;
    private final String source;

    public Screenshot(@Nullable File imageFile, @Nullable String imageUrl, @Nullable String source) {
        this.imageFile = imageFile;
        this.image = imageUrl;
        this.source = source;
    }

    @CheckReturnValue
    @Nullable
    File getImageFile() {
        return this.imageFile;
    }

    @CheckReturnValue
    @Nullable
    public String getImage() {
        return this.image;
    }

    @CheckReturnValue
    @Nullable
    public String getSource() {
        return this.source;
    }

    @CheckReturnValue
    @Nonnull
    public static Screenshot none() {
        return new Screenshot(null, null, null);
    }

    public boolean isPresent() {
        return this.image != null || this.source != null;
    }

    public String summary() {
        if (this.image != null && this.source != null) {
            return String.format("Screenshot: %s%nPage source: %s", this.image, this.source);
        }
        if (this.source != null) {
            return String.format("Page source: %s", this.source);
        }
        if (this.image != null) {
            return String.format("Screenshot: %s", this.image);
        }
        return "";
    }

    public String toString() {
        return this.summary();
    }
}

