/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.FileContent;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WrapsDriver;

@ParametersAreNonnullByDefault
public class JavaScript {
    private final FileContent jsSource;

    public JavaScript(String jsFileName) {
        this.jsSource = new FileContent(jsFileName);
    }

    @Nonnull
    public <T> T execute(SearchContext context, Object ... arguments) {
        String js = "return " + this.jsSource.content();
        return (T)JavaScript.jsExecutor(context).executeScript(js, arguments);
    }

    @Nonnull
    public <T> T execute(Driver driver, Object ... arguments) {
        return this.execute((SearchContext)driver.getWebDriver(), arguments);
    }

    @Nonnull
    @CheckReturnValue
    public <T> T executeOrFail(Driver driver, Object ... arguments) {
        List result = (List)this.execute(driver, arguments);
        if (result.get(1) != null) {
            throw new IllegalArgumentException((String)result.get(1));
        }
        return (T)result.get(0);
    }

    public static JavascriptExecutor jsExecutor(SearchContext context) {
        return JavaScript.asJsExecutor(context).orElseThrow(() -> new IllegalArgumentException("Context is not JS-aware: " + context));
    }

    public static Optional<JavascriptExecutor> asJsExecutor(SearchContext context) {
        Optional<JavascriptExecutor> optional;
        SearchContext unwrappedContext;
        if (context instanceof WrapsDriver) {
            WrapsDriver wrapsDriver = (WrapsDriver)context;
            v0 = wrapsDriver.getWrappedDriver();
        } else {
            v0 = unwrappedContext = context;
        }
        if (unwrappedContext instanceof JavascriptExecutor) {
            JavascriptExecutor jsExecutor = (JavascriptExecutor)unwrappedContext;
            optional = Optional.of(jsExecutor);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Nullable
    public Object node(SearchContext context) {
        return context instanceof WebDriver ? null : context;
    }
}

