/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import java.time.Duration;
import java.util.Locale;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DurationFormat {
    @CheckReturnValue
    public String format(Duration duration) {
        return this.format(duration.toMillis());
    }

    @CheckReturnValue
    public String format(long milliseconds) {
        if (milliseconds < 1000L) {
            return String.format("%d ms.", milliseconds);
        }
        if (milliseconds % 1000L == 0L) {
            return String.format("%d s.", milliseconds / 1000L);
        }
        return String.format(Locale.ROOT, "%.3f s.", (double)milliseconds / 1000.0);
    }
}

