/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Alias {
    private final String text;
    public static final Alias NONE = new NoneAlias();

    public Alias(String text) {
        if (text.isEmpty()) {
            throw new IllegalArgumentException("Empty alias not allowed");
        }
        this.text = text;
    }

    @CheckReturnValue
    public String getOrElse(Supplier<String> defaultValue) {
        return this.text;
    }

    @CheckReturnValue
    public String get(Supplier<String> defaultValue) {
        return this.text + " {" + defaultValue.get() + "}";
    }

    @Nonnull
    @CheckReturnValue
    public String appendable() {
        return this.getText() == null ? "" : " \"" + this.getText() + "\"";
    }

    @Nullable
    @CheckReturnValue
    public String getText() {
        return this.text;
    }

    private static final class NoneAlias
    extends Alias {
        NoneAlias() {
            super("-");
        }

        @Override
        @CheckReturnValue
        public String getOrElse(Supplier<String> defaultValue) {
            return defaultValue.get();
        }

        @Override
        @CheckReturnValue
        public String get(Supplier<String> defaultValue) {
            return defaultValue.get();
        }

        @Override
        @Nullable
        @CheckReturnValue
        public String getText() {
            return null;
        }
    }
}

