/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.files;

import com.codeborne.selenide.files.FileFilter;
import java.io.File;
import org.apache.commons.io.FilenameUtils;

class ExtensionFilter
implements FileFilter {
    private final String extension;

    ExtensionFilter(String extension) {
        if (extension.indexOf(46) > -1) {
            throw new IllegalArgumentException(String.format("File extension cannot contain dot: '%s'", extension));
        }
        this.extension = extension;
    }

    @Override
    public boolean match(File file) {
        return FilenameUtils.isExtension((String)file.getName(), (String)this.extension);
    }

    @Override
    public String description() {
        return " with extension \"" + this.extension + "\"";
    }

    public String toString() {
        return this.description().trim();
    }
}

