/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.drivercommands;

import com.codeborne.selenide.DownloadsFolder;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.WebDriverInstance;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class CloseDriverCommand {
    private static final Logger log = LoggerFactory.getLogger(CloseDriverCommand.class);

    public void close(WebDriverInstance wd) {
        long start;
        WebDriver webDriver = wd.webDriver();
        DownloadsFolder downloadsFolder = wd.downloadsFolder();
        long threadId = Thread.currentThread().getId();
        if (wd.config().holdBrowserOpen()) {
            log.info("Hold browser open: {} -> {}", (Object)threadId, (Object)webDriver);
            return;
        }
        if (downloadsFolder != null) {
            downloadsFolder.deleteIfEmpty();
        }
        if (webDriver != null) {
            start = System.currentTimeMillis();
            log.info("Close webdriver: {} -> {}...", (Object)threadId, (Object)webDriver);
            this.quitSafely(webDriver);
            log.info("Closed webdriver {} in {} ms", (Object)threadId, (Object)(System.currentTimeMillis() - start));
        }
        if (wd.config().proxyEnabled()) {
            start = System.currentTimeMillis();
            SelenideProxyServer proxy = wd.proxy();
            log.info("Close proxy server: {} -> {}...", (Object)threadId, (Object)proxy);
            proxy.shutdown();
            log.info("Closed proxy server {} in {} ms", (Object)threadId, (Object)(System.currentTimeMillis() - start));
        }
    }

    private void quitSafely(WebDriver webdriver) {
        try {
            webdriver.quit();
        }
        catch (NoSuchSessionException e) {
            log.debug("Webdriver has been closed meanwhile", (Throwable)e);
        }
        catch (UnreachableBrowserException e) {
            log.debug("Browser is unreachable", (Throwable)e);
        }
        catch (WebDriverException cannotCloseBrowser) {
            log.error("Cannot close browser: {}", (Object)Cleanup.of.webdriverExceptionMessage(cannotCloseBrowser));
        }
        catch (RuntimeException e) {
            log.error("Cannot close browser", (Throwable)e);
        }
    }
}

