/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.webdriver;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.ObjectCondition;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebDriver;

@ParametersAreNonnullByDefault
public abstract class UrlCondition
implements ObjectCondition<WebDriver> {
    private final String name;
    protected final String expectedUrl;

    protected UrlCondition(String name, String expectedUrl) {
        this.name = name;
        this.expectedUrl = expectedUrl;
    }

    @Override
    @Nullable
    @CheckReturnValue
    public String expectedValue() {
        return this.expectedUrl;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String description() {
        return "should have url " + this.name + this.expectedUrl;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String negativeDescription() {
        return "should not have url " + this.name + this.expectedUrl;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String describe(WebDriver webDriver) {
        return "webdriver";
    }

    @Override
    @CheckReturnValue
    public CheckResult check(WebDriver webDriver) {
        String url = webDriver.getCurrentUrl();
        return this.result(webDriver, this.test(url), url);
    }

    protected abstract boolean test(String var1);
}

