/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.webdriver;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.ObjectCondition;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebDriver;

@ParametersAreNonnullByDefault
public class Title
implements ObjectCondition<WebDriver> {
    private final String expectedTitle;

    public Title(String expectedTitle) {
        this.expectedTitle = expectedTitle;
    }

    @Override
    @Nullable
    @CheckReturnValue
    public String expectedValue() {
        return this.expectedTitle;
    }

    @Override
    @Nonnull
    public String description() {
        return "should have title " + this.expectedTitle;
    }

    @Override
    @Nonnull
    public String negativeDescription() {
        return "should not have title " + this.expectedTitle;
    }

    @Override
    @Nonnull
    public String describe(WebDriver webDriver) {
        return "Page";
    }

    @Override
    @CheckReturnValue
    public CheckResult check(WebDriver webDriver) {
        String title = webDriver.getTitle();
        return this.result(webDriver, title.equals(this.expectedTitle), title);
    }
}

