/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.webdriver;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.ObjectCondition;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebDriver;

@ParametersAreNonnullByDefault
public class NumberOfWindows
implements ObjectCondition<WebDriver> {
    private final int expectedNumberOfWindows;

    public NumberOfWindows(int expectedNumberOfWindows) {
        this.expectedNumberOfWindows = expectedNumberOfWindows;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String description() {
        return "should have " + this.expectedNumberOfWindows + " window(s)";
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String negativeDescription() {
        return "should not have " + this.expectedNumberOfWindows + " window(s)";
    }

    @Override
    @CheckReturnValue
    public CheckResult check(WebDriver webDriver) {
        int count = webDriver.getWindowHandles().size();
        return this.result(webDriver, count == this.expectedNumberOfWindows, String.valueOf(count));
    }

    @Override
    @Nullable
    @CheckReturnValue
    public String expectedValue() {
        return String.valueOf(this.expectedNumberOfWindows);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String describe(WebDriver webDriver) {
        return "webdriver";
    }
}

