/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.webdriver;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.ObjectCondition;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.WebDriver;

@ParametersAreNonnullByDefault
public class CookieWithNameAndValue
implements ObjectCondition<WebDriver> {
    private final String name;
    private final String value;

    public CookieWithNameAndValue(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String description() {
        return String.format("should have a cookie with name \"%s\" and value \"%s\"", this.name, this.value);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String negativeDescription() {
        return String.format("should not have cookie with name \"%s\" and value \"%s\"", this.name, this.value);
    }

    @Override
    @CheckReturnValue
    public CheckResult check(WebDriver webDriver) {
        Cookie cookie = webDriver.manage().getCookieNamed(this.name);
        boolean met = cookie != null && Objects.equals(cookie.getValue(), this.value);
        return this.result(webDriver, met, this.actualValue(webDriver));
    }

    @Nonnull
    @CheckReturnValue
    private String actualValue(WebDriver webDriver) {
        return String.format("Available cookies: %s", webDriver.manage().getCookies());
    }

    @Override
    @Nullable
    @CheckReturnValue
    public String expectedValue() {
        return String.format("cookie with name \"%s\" and value \"%s\"", this.name, this.value);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String describe(@Nonnull WebDriver webDriver) {
        return "webdriver";
    }
}

