/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.localstorage;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.LocalStorage;
import com.codeborne.selenide.ObjectCondition;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ItemWithValue
implements ObjectCondition<LocalStorage> {
    private final String item;
    private final String value;

    public ItemWithValue(String item, String value) {
        this.item = item;
        this.value = value;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String description() {
        return String.format("should have item '%s' with value '%s'", this.item, this.value);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String negativeDescription() {
        return String.format("should not have item '%s' with value '%s'", this.item, this.value);
    }

    @Nonnull
    @CheckReturnValue
    private String actualValue(LocalStorage localStorage) {
        return localStorage.getItems().toString();
    }

    @Override
    @Nullable
    @CheckReturnValue
    public String expectedValue() {
        return String.format("%s=%s", this.item, this.value);
    }

    @Override
    @CheckReturnValue
    public CheckResult check(LocalStorage localStorage) {
        boolean met = Objects.equals(localStorage.getItem(this.item), this.value);
        return this.result(localStorage, met, this.actualValue(localStorage));
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String describe(LocalStorage localStorage) {
        return "localStorage";
    }
}

