/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.WebElementCondition;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class TagName
extends WebElementCondition {
    private final String expectedTagName;

    public TagName(String expectedTagName) {
        super("tag name");
        this.expectedTagName = expectedTagName;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public CheckResult check(Driver driver, WebElement element) {
        String actualTagName = element.getTagName();
        boolean matches = Objects.equals(actualTagName, this.expectedTagName);
        return new CheckResult(matches, (Object)String.format("tag \"%s\"", actualTagName));
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String toString() {
        return String.format("tag \"%s\"", this.expectedTagName);
    }
}

