/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.impl.Html;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class PartialValue
extends WebElementCondition {
    private final String expectedValue;

    public PartialValue(String expectedValue) {
        super("partial value");
        this.expectedValue = expectedValue;
        if (StringUtils.isEmpty((CharSequence)expectedValue)) {
            throw new IllegalArgumentException("Argument must not be null or empty string. Use $.shouldBe(empty) or $.shouldHave(exactValue(\"\").");
        }
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public CheckResult check(Driver driver, WebElement element) {
        String value = this.getValueAttribute(element);
        String actualValue = String.format("value=\"%s\"", value);
        boolean valueMatches = Html.text.contains(value, this.expectedValue);
        return new CheckResult(valueMatches, (Object)actualValue);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String toString() {
        return String.format("%s \"%s\"", this.getName(), this.expectedValue);
    }

    private String getValueAttribute(WebElement element) {
        String attr = element.getAttribute("value");
        return attr == null ? "" : attr;
    }
}

