/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.WebElementCondition;
import java.util.function.Predicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class CustomMatch
extends WebElementCondition {
    protected final Predicate<WebElement> predicate;

    public CustomMatch(String description, Predicate<WebElement> predicate) {
        super(description);
        this.predicate = predicate;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public CheckResult check(Driver driver, WebElement element) {
        boolean matched = this.predicate.test(element);
        return new CheckResult(matched, null);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String toString() {
        return String.format("match '%s' predicate.", this.getName());
    }
}

