/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.Stopwatch;
import com.codeborne.selenide.TypeOptions;
import com.codeborne.selenide.commands.Clear;
import com.codeborne.selenide.commands.Util;
import com.codeborne.selenide.impl.Plugins;
import com.codeborne.selenide.impl.WebElementSource;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class Type
implements Command<SelenideElement> {
    private final Clear clear;

    public Type() {
        this(Plugins.inject(Clear.class));
    }

    protected Type(Clear clear) {
        this.clear = clear;
    }

    @Override
    @Nullable
    public SelenideElement execute(SelenideElement proxy, WebElementSource locator, Object[] args) {
        TypeOptions typeOptions = this.extractOptions(Objects.requireNonNull(args));
        this.clearField(proxy, locator, typeOptions);
        WebElement element = this.findElement(locator);
        this.typeIntoField(element, typeOptions);
        return proxy;
    }

    @Nonnull
    @CheckReturnValue
    protected WebElement findElement(WebElementSource locator) {
        return locator.findAndAssertElementIsEditable();
    }

    private TypeOptions extractOptions(Object[] args) {
        Object object = args[0];
        if (object instanceof TypeOptions) {
            TypeOptions options = (TypeOptions)object;
            return options;
        }
        return TypeOptions.text((CharSequence)Util.firstOf(args));
    }

    private void typeIntoField(WebElement element, TypeOptions typeOptions) {
        for (int i = 0; i < typeOptions.textToType().length(); ++i) {
            CharSequence character = typeOptions.textToType().subSequence(i, i + 1);
            element.sendKeys(new CharSequence[]{character});
            Stopwatch.sleepAtLeast(typeOptions.timeDelay().toMillis());
        }
    }

    private void clearField(SelenideElement proxy, WebElementSource locator, TypeOptions typeOptions) {
        if (typeOptions.shouldClearFieldBeforeTyping()) {
            if (typeOptions.textToType().length() > 0) {
                this.clear.clear(locator.driver(), proxy);
            } else {
                this.clear.clearAndTrigger(locator.driver(), proxy);
            }
        }
    }
}

