/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.collections;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.collections.ExactTexts;
import com.codeborne.selenide.impl.ElementCommunicator;
import com.codeborne.selenide.impl.Html;
import com.codeborne.selenide.impl.Plugins;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class TextsInAnyOrder
extends ExactTexts {
    private static final ElementCommunicator communicator = Plugins.inject(ElementCommunicator.class);

    public TextsInAnyOrder(String ... expectedTexts) {
        super(expectedTexts);
    }

    public TextsInAnyOrder(List<String> expectedTexts) {
        super(expectedTexts);
    }

    @Override
    @Nonnull
    public CheckResult check(Driver driver, List<WebElement> elements) {
        List<String> actualTexts = communicator.texts(driver, elements);
        if (actualTexts.size() != this.expectedTexts.size()) {
            String message = String.format("List size mismatch (expected: %s, actual: %s)", this.expectedTexts.size(), actualTexts.size());
            return CheckResult.rejected(message, actualTexts);
        }
        for (int i = 0; i < this.expectedTexts.size(); ++i) {
            String expectedText = (String)this.expectedTexts.get(i);
            boolean found = this.find(actualTexts, expectedText);
            if (found) continue;
            String message = String.format("Text #%s not found: \"%s\"", i, expectedText);
            return CheckResult.rejected(message, actualTexts);
        }
        return CheckResult.accepted();
    }

    private boolean find(List<String> texts, String text) {
        for (String elementText : texts) {
            if (!Html.text.contains(elementText, text)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "TextsInAnyOrder " + this.expectedTexts;
    }
}

