/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.Stopwatch;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.UIAssertionError;
import com.codeborne.selenide.impl.BySelectorCollection;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.CollectionElement;
import com.codeborne.selenide.impl.CollectionElementByCondition;
import com.codeborne.selenide.impl.CollectionSnapshot;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.ElementCommunicator;
import com.codeborne.selenide.impl.FilteringCollection;
import com.codeborne.selenide.impl.HeadOfCollection;
import com.codeborne.selenide.impl.LastCollectionElement;
import com.codeborne.selenide.impl.Plugins;
import com.codeborne.selenide.impl.SelenideElementIterator;
import com.codeborne.selenide.impl.TailOfCollection;
import com.codeborne.selenide.impl.WebElementsCollectionWrapper;
import com.codeborne.selenide.logevents.ErrorsCollector;
import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.SelenideLog;
import com.codeborne.selenide.logevents.SelenideLogger;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class ElementsCollection {
    private static final ElementCommunicator communicator = Plugins.inject(ElementCommunicator.class);
    private final CollectionSource collection;

    public ElementsCollection(CollectionSource collection) {
        this.collection = collection;
    }

    public ElementsCollection(Driver driver, Collection<? extends WebElement> elements) {
        this(new WebElementsCollectionWrapper(driver, elements));
    }

    public ElementsCollection(Driver driver, String cssSelector) {
        this(driver, By.cssSelector((String)cssSelector));
    }

    public ElementsCollection(Driver driver, By seleniumSelector) {
        this(new BySelectorCollection(driver, seleniumSelector));
    }

    @Nonnull
    public ElementsCollection should(CollectionCondition ... conditions) {
        return this.should("", Duration.ofMillis(this.driver().config().timeout()), conditions);
    }

    @Nonnull
    public ElementsCollection should(CollectionCondition condition, Duration timeout) {
        return this.should("", timeout, this.toArray(condition));
    }

    @Nonnull
    public ElementsCollection shouldBe(CollectionCondition ... conditions) {
        return this.should("be", Duration.ofMillis(this.driver().config().timeout()), conditions);
    }

    @Nonnull
    public ElementsCollection shouldBe(CollectionCondition condition, Duration timeout) {
        return this.should("be", timeout, this.toArray(condition));
    }

    @Nonnull
    public ElementsCollection shouldHave(CollectionCondition ... conditions) {
        return this.should("have", Duration.ofMillis(this.driver().config().timeout()), conditions);
    }

    @Nonnull
    public ElementsCollection shouldHave(CollectionCondition condition, Duration timeout) {
        return this.should("have", timeout, this.toArray(condition));
    }

    @CheckReturnValue
    @Nonnull
    private CollectionCondition[] toArray(CollectionCondition condition) {
        return new CollectionCondition[]{condition};
    }

    @Nonnull
    protected ElementsCollection should(String prefix, Duration timeout, CollectionCondition ... conditions) {
        ErrorsCollector.validateAssertionMode(this.driver().config());
        SelenideLog log = SelenideLogger.beginStep(this.collection.shortDescription(), "should " + prefix, conditions);
        try {
            for (CollectionCondition condition : conditions) {
                this.waitUntil(condition, timeout);
            }
            SelenideLogger.commitStep(log, LogEvent.EventStatus.PASS);
            return this;
        }
        catch (Error error) {
            Error wrappedError = UIAssertionError.wrap(this.driver(), error, timeout.toMillis());
            SelenideLogger.commitStep(log, wrappedError);
            switch (this.driver().config().assertionMode()) {
                case SOFT: {
                    break;
                }
                default: {
                    throw wrappedError;
                }
            }
            return this;
        }
        catch (RuntimeException e) {
            SelenideLogger.commitStep(log, e);
            throw e;
        }
    }

    protected void waitUntil(CollectionCondition condition, Duration timeout) {
        Object lastError = null;
        CheckResult lastCheckResult = new CheckResult(CheckResult.Verdict.REJECT, null);
        Stopwatch stopwatch = new Stopwatch(timeout.toMillis());
        do {
            try {
                lastCheckResult = condition.check(this.collection);
                if (lastCheckResult.verdict() == CheckResult.Verdict.ACCEPT) {
                    return;
                }
            }
            catch (JavascriptException e) {
                throw e;
            }
            catch (UIAssertionError | IndexOutOfBoundsException | WebDriverException elementNotFound) {
                if (Cleanup.of.isInvalidSelectorError((Throwable)elementNotFound)) {
                    throw Cleanup.of.wrapInvalidSelectorException((Throwable)elementNotFound);
                }
                if (condition.missingElementSatisfiesCondition()) {
                    return;
                }
                lastError = elementNotFound;
            }
            this.sleep(this.driver().config().pollingInterval());
        } while (!stopwatch.isTimeoutReached());
        if (lastError instanceof IndexOutOfBoundsException) {
            throw new ElementNotFound(this.collection.driver(), this.collection.getAlias(), this.collection.description(), Condition.exist, (Throwable)lastError);
        }
        if (lastError instanceof UIAssertionError) {
            UIAssertionError uiAssertionError = (UIAssertionError)((Object)lastError);
            throw uiAssertionError;
        }
        condition.fail(this.collection, lastCheckResult, (Exception)lastError, timeout.toMillis());
    }

    void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection filter(WebElementCondition condition) {
        return new ElementsCollection(new FilteringCollection(this.collection, condition));
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection filterBy(WebElementCondition condition) {
        return this.filter(condition);
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection exclude(WebElementCondition condition) {
        return new ElementsCollection(new FilteringCollection(this.collection, Condition.not(condition)));
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection excludeWith(WebElementCondition condition) {
        return this.exclude(condition);
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElement find(WebElementCondition condition) {
        return CollectionElementByCondition.wrap(this.collection, condition);
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElement findBy(WebElementCondition condition) {
        return this.find(condition);
    }

    @CheckReturnValue
    @Nonnull
    private List<WebElement> getElements() {
        return this.collection.getElements();
    }

    @CheckReturnValue
    @Nonnull
    public List<String> texts() {
        return communicator.texts(this.driver(), this.getElements());
    }

    @CheckReturnValue
    @Nonnull
    public List<String> attributes(String attribute) {
        return communicator.attributes(this.driver(), this.getElements(), attribute);
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElement get(int index) {
        return CollectionElement.wrap(this.collection, index);
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElement first() {
        return this.get(0);
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElement last() {
        return LastCollectionElement.wrap(this.collection);
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection first(int elements) {
        return new ElementsCollection(new HeadOfCollection(this.collection, elements));
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection last(int elements) {
        return new ElementsCollection(new TailOfCollection(this.collection, elements));
    }

    @CheckReturnValue
    public int size() {
        try {
            return this.getElements().size();
        }
        catch (IndexOutOfBoundsException outOfCollection) {
            return 0;
        }
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection snapshot() {
        return new ElementsCollection(new CollectionSnapshot(this.collection));
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElementIterable asFixedIterable() {
        return () -> new SelenideElementIterator(new CollectionSnapshot(this.collection));
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElementIterable asDynamicIterable() {
        return () -> new SelenideElementIterator(this.collection);
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection as(String alias) {
        this.collection.setAlias(alias);
        return this;
    }

    @CheckReturnValue
    public String toString() {
        return this.collection.getAlias().getOrElse(this.collection::toString);
    }

    @CheckReturnValue
    @Nonnull
    private Driver driver() {
        return this.collection.driver();
    }

    @FunctionalInterface
    public static interface SelenideElementIterable
    extends Iterable<SelenideElement> {
        default public Stream<SelenideElement> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }
    }
}

