/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.webdriver.HttpClientTimeouts;
import com.google.auto.service.AutoService;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpClientName;
import org.openqa.selenium.remote.http.netty.NettyClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HttpClientName(value="selenide-netty-client-factory")
@AutoService(value={HttpClient.Factory.class})
public class SelenideNettyClientFactory
extends NettyClient.Factory {
    private static final Logger logger = LoggerFactory.getLogger(SelenideNettyClientFactory.class);

    public HttpClient createClient(ClientConfig config) {
        ClientConfig configWithShorterTimeout = config.readTimeout(HttpClientTimeouts.defaultLocalReadTimeout).connectionTimeout(HttpClientTimeouts.defaultLocalConnectTimeout);
        if (!config.readTimeout().equals(HttpClientTimeouts.defaultLocalReadTimeout)) {
            logger.info("Changed readTimeout from {} to {}", (Object)config.readTimeout(), (Object)configWithShorterTimeout.readTimeout());
        }
        if (!config.connectionTimeout().equals(HttpClientTimeouts.defaultLocalConnectTimeout)) {
            logger.info("Changed connectionTimeout from {} to {}", (Object)config.connectionTimeout(), (Object)configWithShorterTimeout.connectionTimeout());
        }
        return super.createClient(configWithShorterTimeout);
    }
}

