/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ex.ElementIsNotClickableException;
import com.codeborne.selenide.ex.InvalidStateException;
import com.codeborne.selenide.ex.UIAssertionError;
import com.codeborne.selenide.impl.WebElementSource;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriverException;

@ParametersAreNonnullByDefault
class ExceptionWrapper {
    ExceptionWrapper() {
    }

    @CheckReturnValue
    @Nonnull
    Throwable wrap(Throwable error, WebElementSource webElementSource) {
        if (error instanceof UIAssertionError) {
            return error;
        }
        if (error instanceof InvalidElementStateException) {
            return new InvalidStateException(webElementSource.driver(), webElementSource.description(), error);
        }
        if (this.isElementNotClickableException(error)) {
            return new ElementIsNotClickableException(webElementSource.driver(), webElementSource.description(), error);
        }
        if (error instanceof StaleElementReferenceException || error instanceof NotFoundException) {
            return webElementSource.createElementNotFoundError(Condition.exist, error);
        }
        return error;
    }

    @CheckReturnValue
    private boolean isElementNotClickableException(Throwable e) {
        return e instanceof WebDriverException && e.getMessage().contains("is not clickable");
    }
}

