/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.ex;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ObjectCondition;
import com.codeborne.selenide.ex.ErrorFormatter;
import com.codeborne.selenide.ex.Strings;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.DurationFormat;
import com.codeborne.selenide.impl.Screenshot;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class SelenideErrorFormatter
implements ErrorFormatter {
    private static final DurationFormat df = new DurationFormat();

    @Override
    @CheckReturnValue
    @Nonnull
    public String generateErrorDetails(AssertionError error, Driver driver, Screenshot screenshot, long timeoutMs) {
        return Strings.join(screenshot.summary(), this.timeout(timeoutMs), this.causedBy(((Throwable)((Object)error)).getCause()));
    }

    @CheckReturnValue
    @Nonnull
    protected String timeout(long timeoutMs) {
        return String.format("Timeout: %s", df.format(timeoutMs));
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String actualValue(Condition condition, Driver driver, @Nullable WebElement element, @Nullable CheckResult lastCheckResult) {
        if (lastCheckResult != null && lastCheckResult.actualValue() != null) {
            return String.format("Actual value: %s", lastCheckResult.actualValue());
        }
        String actualValue = this.extractActualValue(condition, driver, element);
        if (actualValue != null) {
            return String.format("Actual value: %s", actualValue);
        }
        return "";
    }

    @Nullable
    @CheckReturnValue
    protected String extractActualValue(Condition condition, Driver driver, @Nullable WebElement element) {
        if (element != null) {
            try {
                return condition.actualValue(driver, element);
            }
            catch (RuntimeException failedToGetValue) {
                String failedActualValue = failedToGetValue.getClass().getSimpleName() + ": " + failedToGetValue.getMessage();
                return StringUtils.substring((String)failedActualValue, (int)0, (int)50);
            }
        }
        return null;
    }

    @CheckReturnValue
    @Nonnull
    protected <T> String actualValue(ObjectCondition<T> condition, @Nullable T object) {
        if (object == null) {
            return "";
        }
        return this.formatActualValue(this.extractActualValue(condition, object));
    }

    @CheckReturnValue
    @Nonnull
    protected String causedBy(@Nullable Throwable cause) {
        if (cause == null) {
            return "";
        }
        return String.format("Caused by: %s", Cleanup.of.webdriverExceptionMessage(cause));
    }
}

