/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.drivercommands;

import com.codeborne.selenide.BasicAuthCredentials;
import com.codeborne.selenide.Credentials;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.HasAuthentication;
import org.openqa.selenium.UsernameAndPassword;
import org.openqa.selenium.WebDriver;

@ParametersAreNonnullByDefault
public class BasicAuthUtils {
    @Nonnull
    static String appendBasicAuthToURL(String url, @Nullable BasicAuthCredentials credentials) {
        if (credentials == null) {
            return url;
        }
        String login = credentials.login.isEmpty() ? "" : BasicAuthUtils.encode(credentials.login) + ':';
        String password = credentials.password.isEmpty() ? "" : BasicAuthUtils.encode(credentials.password) + "@";
        int index = url.indexOf("://");
        return index < 0 ? login + password + url : url.substring(0, index) + "://" + login + password + url.substring(index + 3);
    }

    @Nonnull
    @CheckReturnValue
    private static String encode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @CheckReturnValue
    public static boolean registerBasicAuth(WebDriver webDriver, @Nullable Credentials credentials) {
        if (webDriver instanceof HasAuthentication) {
            HasAuthentication hasAuthentication = (HasAuthentication)webDriver;
            if (credentials instanceof BasicAuthCredentials) {
                BasicAuthCredentials basicAuth = (BasicAuthCredentials)credentials;
                hasAuthentication.register(uri -> BasicAuthUtils.uriMatchesDomain(uri, basicAuth.domain()), UsernameAndPassword.of((String)basicAuth.login, (String)basicAuth.password));
                return true;
            }
        }
        return false;
    }

    @CheckReturnValue
    public static boolean uriMatchesDomain(String url, String domain) {
        return BasicAuthUtils.hostMatchesDomain(BasicAuthUtils.getHostname(url), domain);
    }

    @CheckReturnValue
    static boolean uriMatchesDomain(URI uri, String domain) {
        return BasicAuthUtils.hostMatchesDomain(uri.getHost(), domain);
    }

    private static boolean hostMatchesDomain(@Nullable String host, String domain) {
        if (domain.isEmpty()) {
            return true;
        }
        if (host == null) {
            return false;
        }
        List<String> domains = Arrays.asList(domain.toLowerCase(Locale.ROOT).split("[,|]"));
        return domains.contains(host.toLowerCase(Locale.ROOT));
    }

    @Nullable
    @CheckReturnValue
    static String getHostname(String url) {
        try {
            return new URI(url).getHost();
        }
        catch (URISyntaxException invalidUri) {
            return url;
        }
    }
}

