/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.clipboard;

import com.codeborne.selenide.Clipboard;
import com.codeborne.selenide.ObjectCondition;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Content
implements ObjectCondition<Clipboard> {
    private final String expectedContent;

    public Content(String expectedContent) {
        this.expectedContent = expectedContent;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String description() {
        return String.format("should have content '%s'", this.expectedContent);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String negativeDescription() {
        return String.format("should not have content '%s'", this.expectedContent);
    }

    @Override
    @CheckReturnValue
    public boolean test(Clipboard clipboard) {
        return clipboard.getText().equals(this.expectedContent);
    }

    @Override
    @Nullable
    @CheckReturnValue
    public String actualValue(Clipboard clipboard) {
        return clipboard.getText();
    }

    @Override
    @Nullable
    @CheckReturnValue
    public String expectedValue() {
        return this.expectedContent;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String describe(Clipboard clipboard) {
        return "clipboard";
    }
}

